#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// [ConcoursJFIG2024] Rose WindowMod01.fsh  by  Melodix    
//https://www.shadertoy.com/view/lXsBDf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Rose Window - Strasbourg//

float time() { return iTime; }
vec2 res() { return iResolution.xy; }

// Procedural pattern generation for animated background with zoom effects
float animatedZoomBackgroundPattern(vec2 position) {
    // Define a zoom oscillation factor to create a dynamic zoom in/out effect
    float zoomOscillation = 0.8 + sin(time() * 0.3) * 0.6;  // Ranges between 0.7 and 1.3

    // Apply zoom to the position coordinates
    position *= zoomOscillation;
    
    // Wrap the x-coordinate for tiling effects
    position.x = mod(position.x + 2.0, 2.0) - 0.3;
    
    float minDistance = 100.0;  // Initial high value to find the minimum distance in loop

    // Iterative fractal-like effect for background pattern
    for (int i = 0; i < 6; i++) {
        position = abs(position) / clamp(dot(position, position), 0.36, 1.1) - vec2(0.75);
        minDistance = min(minDistance, 19.8 * abs(position.y));  // Update with the minimum distance
    }
    
    return minDistance;
}

// Generate pattern for the inner region of the middle circle with refined scaling and modulation
float innerMiddleCirclePattern(vec2 position) {
    // Slight scaling to adjust pattern detail
    position *= 0.9;

    // Convert position to polar coordinates
    float radialDistance = length(position);
    float angle = atan(position.y, position.x);

    // Modulate radial and angular coordinates for pattern repetition
    radialDistance = mod(radialDistance * 4.5, 1.5);
    angle = mod(angle * 3.5, 7.5);

    // Initial pattern function using trigonometric shape adjustments
    float patternIntensity = cos(radialDistance * 6.0) + sin(angle * 5.0);

    // Apply iterative fractal-like transformations for more complexity
    for (int i = 0; i < 7; i++) {
        position = abs(position) / clamp(dot(position, position), 0.3, 1.3) - vec2(0.75);
        patternIntensity = min(patternIntensity, 3.0 * abs(position.y));
    }

    return patternIntensity;
}


// Generate pattern for the inner middle circle with opposite rotation effect
float innerMiddleCircleOppositeRotationPattern(vec2 position) {
    // Scale down position for refined pattern
    position *= 0.5;

    // Apply a time-based rotation transformation
    float rotationAngle = time() * 0.1;
    float cosAngle = cos(rotationAngle);
    float sinAngle = sin(rotationAngle);
    position = vec2(cosAngle * position.x - sinAngle * position.y, sinAngle * position.x + cosAngle * position.y);

    // Convert to polar coordinates
    float radialDistance = length(position);
    float angle = atan(position.y, position.x);

    // Modulate radial and angular coordinates for pattern repetition
    radialDistance = mod(radialDistance * 5.5, 1.5);
    angle = mod(angle * 6.0, 7.5);

    // Initial pattern intensity using trigonometric adjustments
    float patternIntensity = cos(radialDistance * 0.5) + sin(angle * 6.0);

    // Fractal-like transformations for added complexity
    for (int i = 0; i < 5; i++) {
        position = abs(position) / clamp(dot(position, position), 0.5, 1.3) - vec2(0.95);
        patternIntensity = min(patternIntensity, 4.0 * abs(position.y));
    }

    return patternIntensity;
}

// Generate pattern for the outer region of the middle circle with opposite rotation
float outerMiddleCircleOppositeRotationPattern(vec2 position) {
    // Scale down position slightly for refined patterns
    position *= 0.9;

    // Apply a time-based reverse rotation transformation
    float rotationAngle = time() * 0.1;
    float cosAngle = cos(rotationAngle);
    float sinAngle = sin(rotationAngle);
    position = vec2(cosAngle * position.x - sinAngle * position.y, sinAngle * position.x + cosAngle * position.y);

    // Convert to polar coordinates
    float radialDistance = length(position);
    float angle = atan(position.y, position.x);

    // Modulate radial and angular coordinates for pattern repetition
    radialDistance = mod(radialDistance * 4.5, 1.5);
    angle = mod(angle * 3.5, 7.5);

    // Define initial pattern intensity with trigonometric adjustments
    float patternIntensity = cos(radialDistance * 5.0) + sin(angle * 5.0);

    // Apply iterative transformations for complexity
    for (int i = 0; i < 6; i++) {
        position = abs(position) / clamp(dot(position, position), 0.15, 1.2) - vec2(0.75);
        patternIntensity = min(patternIntensity, 4.0 * abs(position.y));
    }

    return patternIntensity;
}


// Generate pattern for the outer window region with rotational effect
float outerWindowRotationPattern(vec2 position) {
    // Apply scaling for refined pattern
    position *= 0.9;

    // Apply time-based rotation transformation for dynamic effect
    float rotationAngle = time() * 0.1;
    float cosAngle = cos(rotationAngle);
    float sinAngle = sin(rotationAngle);
    position = vec2(cosAngle * position.x - sinAngle * position.y, sinAngle * position.x + cosAngle * position.y);

    // Convert position to polar coordinates
    float radialDistance = length(position);
    float angle = atan(position.y, position.x);

    // Modulate radial and angular coordinates for pattern repetition
    radialDistance = mod(radialDistance * 4.5, 1.5);
    angle = mod(angle * 3.5, 7.5);

    // Define initial pattern intensity using trigonometric adjustments
    float patternIntensity = cos(radialDistance * 5.0) + sin(angle * 5.0);

    // Apply iterative transformations for a fractal-like effect
    for (int i = 0; i < 7; i++) {
        position = abs(position) / clamp(dot(position, position), 0.3, 1.3) - vec2(0.75);
        patternIntensity = min(patternIntensity, 6.0 * abs(position.y));
    }

    return patternIntensity;
}


// Create fully filled circular shapes in the center with 5 arms
vec3 renderCircularShapes(vec2 uv) {
    uv *= 25.0;  // Scale the shapes (adjust this as needed)
    float radius = length(uv);  // Get distance from the center
    
    // Create 5 arms using the atan function to control the number of repetitions
    float circlePattern = cos(atan(uv.y, uv.x) * 5.0) * 0.3;  // 5 arms with reduced repetition
    float circleRadius = pow(radius, 2.5);  // Control the circular size with rounder shapes
    
    // Combine the pattern and radius to define the circular shapes
    float combinedShapes = abs(circlePattern - circleRadius);
    
    // Define the smooth edges for the circles, filling them fully
    float smoothEdge = smoothstep(0.6, 0.07, combinedShapes);  // Smooth, rounder edges with more fill

    // Solid green color for the circular shapes
    vec3 circleColor = vec3(0.3, 0.75, 0.3);  // Medium green
    
    // Return the fully filled circular shapes
    return circleColor * smoothEdge;
}


// Render the thin black border around the red circle
vec3 renderBlackBorder(vec2 uv) {
    float radius = length(uv) * 16.0;  // Match the red circle size scaling

    // Define a black region right after the red circle
    float borderShape = smoothstep(0.65, 0.9, radius);  // Adjust the range to create a visible black region
    vec3 blackColor = vec3(0.0, 0.0, 0.0);  // Black color for the border

    return blackColor * (.0 - borderShape);  // Fill the region right after the red circle
}

// Simulate 3D lighting for the frame with procedural patterns and varying thickness
vec3 calculateFrameLighting(vec2 uv, float distFromCenter, float windowRadius) {
    float edgeDist = abs(distFromCenter - windowRadius);

    // Procedural pattern for varying frame thickness using cos and sin
    float randomPattern = 0.07 + 0.01 * cos(uv.x * 50.0 + time() * 1.5) * sin(uv.y * 40.0 + time() * 2.0);
    float edge = smoothstep(randomPattern - 0.01, randomPattern + 0.02, edgeDist);

    // Simulate light direction and diffuse effect
    vec3 lightDir = normalize(vec3(-0.5, 0.5, 1.0));
    vec3 normal = normalize(vec3(uv, 0.1));

    float diffuse = max(dot(normal, lightDir), 0.0);

    // Change the frame color to black
    vec3 frameColor = vec3(0.15);  // Black frame color

    vec3 shadowColor = vec3(0.5, 0.15, 0.12) * (1.0 - edge);
    
    return mix(frameColor, shadowColor, edge);
}

// // Bump mapping for the inner middle circle pattern
vec3 bumpInnerMiddleCircle(vec2 position) {
    vec2 offset = vec2(0.008, 0.0);
    vec3 gradient = vec3(
        innerMiddleCirclePattern(position + offset.xy) - innerMiddleCirclePattern(position - offset.xy),
        innerMiddleCirclePattern(position + offset.yx) - innerMiddleCirclePattern(position - offset.yx),
        -0.3);
    return normalize(gradient);
}

// Bump mapping for the inner middle circle with opposite rotation pattern
vec3 bumpInnerMiddleCircleOppositeRotation(vec2 position) {
    vec2 offset = vec2(0.008, 0.0);
    vec3 gradient = vec3(
        innerMiddleCircleOppositeRotationPattern(position + offset.xy) - innerMiddleCircleOppositeRotationPattern(position - offset.xy),
        innerMiddleCircleOppositeRotationPattern(position + offset.yx) - innerMiddleCircleOppositeRotationPattern(position - offset.yx),
        -0.3);
    return normalize(gradient);
}


// Bump mapping for the outer middle circle with opposite rotation pattern
vec3 bumpOuterMiddleCircleOppositeRotation(vec2 position) {
    vec2 offset = vec2(0.008, 0.0);
    vec3 gradient = vec3(
        outerMiddleCircleOppositeRotationPattern(position + offset.xy) - outerMiddleCircleOppositeRotationPattern(position - offset.xy),
        outerMiddleCircleOppositeRotationPattern(position + offset.yx) - outerMiddleCircleOppositeRotationPattern(position - offset.yx),
        -0.3);
    return normalize(gradient);
}


// Bump mapping for the outer window rotation pattern
vec3 bumpOuterWindowRotationPattern(vec2 position) {
    vec2 offset = vec2(0.008, 0.0);
    vec3 gradient = vec3(
        outerWindowRotationPattern(position + offset.xy) - outerWindowRotationPattern(position - offset.xy),
        outerWindowRotationPattern(position + offset.yx) - outerWindowRotationPattern(position - offset.yx),
        -0.3);
    return normalize(gradient);
}


// Bump mapping for the background procedural texture
vec3 bumpBackground(vec2 position) {
    vec2 h = vec2(0.008, 0.0);
    vec3 gradient = vec3(
        animatedZoomBackgroundPattern(position + h.xy) - animatedZoomBackgroundPattern(position - h.xy),
        animatedZoomBackgroundPattern(position + h.yx) - animatedZoomBackgroundPattern(position - h.yx),
        -0.3);
    return normalize(gradient);
}

// Function for rendering the procedural texture inside the circular window
vec3 renderProceduralTextureInWindow(vec2 position, float distFromCenter, float windowRadius) {
    vec3 col;

    // Smooth blending factors between the circles
    float innerBlend = smoothstep(windowRadius * 0.12, windowRadius * 0.15, distFromCenter);
    float middleBlend = smoothstep(windowRadius * 0.40, windowRadius * 0.48, distFromCenter);
    float outerBlend = smoothstep(windowRadius * 0.70, windowRadius * 0.75, distFromCenter);

    // Inner circle (light blue)
    vec3 innerCircleColor = vec3(0.6, 0.9, 1.0);
    vec3 normalMap1 = bumpInnerMiddleCircle(position);
    float lighting1 = 0.01 + 0.4 * dot(normalMap1, vec3(0.0, 0.0, 1.0));
    innerCircleColor *= lighting1;
    innerCircleColor = mix(innerCircleColor, vec3(1.0, 0.9, 0.8), 0.7 * innerMiddleCirclePattern(position));

    // Middle circle (gradient from light blue to dark blue)
    vec3 middleCircleColor = vec3(0.98, 0.99, 1.0);  // Light blue, almost white
    vec3 normalMap2 = bumpInnerMiddleCircleOppositeRotation(position);
    float lighting2 = 0.7 + 0.4 * dot(normalMap2, vec3(0.0, 0.0, 1.0));
    vec3 darkBlue = vec3(0.0, 0.0, 1.0);
    float gradientFactor = smoothstep(0.36, 0.40, distFromCenter / windowRadius);  // Gradient from light blue to dark blue
    middleCircleColor = mix(middleCircleColor, darkBlue, gradientFactor) * lighting2;
    middleCircleColor = mix(middleCircleColor, vec3(1.0, 0.9, 0.8), 0.7 * innerMiddleCircleOppositeRotationPattern(position));

    // Second middle circle (red, orange, yellow, green gradient with thicker yellow)
    vec3 outerCircleColor;
    {
        vec3 normalMap3 = bumpOuterMiddleCircleOppositeRotation(position); 
        float lighting3 = 0.6 + 0.4 * dot(normalMap3, vec3(0.0, 0.0, 1.0));

        // Define colors for red, orange, yellow (thicker), and green
        vec3 red = vec3(1.0, 0.0, 0.0);
        vec3 orange = vec3(1.0, 0.5, 0.0);
        vec3 yellow = vec3(1.0, 1.0, 0.0);
        vec3 green = vec3(0.0, 1.0, 0.0);

        // Smooth color transitions: Red -> Orange -> Yellow (thicker) -> Green
        float redToOrange = smoothstep(0.20, 0.45, distFromCenter / windowRadius);
        float orangeToYellow = smoothstep(0.40, 0.65, distFromCenter / windowRadius);
        float yellowToGreen = smoothstep(0.66, 0.70, distFromCenter / windowRadius);

        // Apply the gradient transitions
        outerCircleColor = mix(red, orange, redToOrange);
        outerCircleColor = mix(outerCircleColor, yellow, orangeToYellow);  // Yellow section is thicker
        outerCircleColor = mix(outerCircleColor, green, yellowToGreen);
        outerCircleColor *= lighting3;
        outerCircleColor = mix(outerCircleColor, vec3(0.8, 0.6, 0.9), 0.6 * outerMiddleCircleOppositeRotationPattern(position));  // Add procedural pattern
    }

    // Outer circle section (outer part of the window)
    vec3 normalMap4 = bumpOuterWindowRotationPattern(position); 
    float lighting4 = 0.6 + 0.4 * dot(normalMap4, vec3(0.0, 0.0, 1.0));
    vec3 finalOuterCircleColor = vec3(0.4, 0.5, 0.2) * lighting4;  // Base color for the outer circle
    finalOuterCircleColor = mix(finalOuterCircleColor, vec3(1.0, 0.9, 0.6), 0.5 * outerWindowRotationPattern(position));

    // Smoothly blend between the different circles
    col = mix(innerCircleColor, middleCircleColor, innerBlend);
    col = mix(col, outerCircleColor, middleBlend);
    col = mix(col, finalOuterCircleColor, outerBlend);

    return col;
}


// Function to render the blackish background with bright blue highlights
vec3 renderBackground(vec2 position) {
    // Blackish base color
    vec3 blackishColor = vec3(0.1, 0.1, 0.1);  // Very dark, almost black color
    
    // Bump mapping to generate the normal for the lighting effect
    vec3 sn = bumpBackground(position);  

    // Constant lighting with variation based on dot product (to simulate 3D lighting)
    float constantLighting = 0.4 + 0.4 * dot(sn, vec3(0.0, 0.0, 1.0));

    // Brighter blue color for areas with more light
    vec3 brightBlue = vec3(0.4, 0.8, 1.0);  // Brighter blue color

    // Start with the blackish base color
    vec3 col = blackishColor * constantLighting;

    // Mix the blackish base color with the brighter blue based on lighting intensity
    col = mix(col, brightBlue, smoothstep(0.5, 1.0, constantLighting));  // More blue in well-lit areas

    // Apply the procedural pattern for additional variation
    col = mix(col, vec3(0.9, 0.5, 0.3), 0.7 * animatedZoomBackgroundPattern(position));  // Introduce more pattern variation

    // Slightly darken the overall effect to keep the blackish feel
    col *= 0.05;

    return col;
}

// Function to draw radial dark gray petals with extended tips forming triangles
float drawConnectedDarkGrayPetals(vec2 uv, int numPetals, float thickness, float angleOffset, float extensionLength) {
    // Normalize the distance from the center
    float radius = length(uv);

    // Calculate the angle for the petal based on uv coordinates
    float angle = atan(uv.y, uv.x);

    // Apply rotation transformation to synchronize with the circles
    float rotationSpeed = time() * 0.1;
    float cosAngle = cos(rotationSpeed);
    float sinAngle = sin(rotationSpeed);
    uv = vec2(cosAngle * uv.x - sinAngle * uv.y, sinAngle * uv.x + cosAngle * uv.y);
    
    // Calculate the angle offset for controlling petal orientation
    angle = atan(uv.y, uv.x) + angleOffset;

    // Calculate the petal angle interval based on the number of petals
    float petalAngle = mod(angle * float(numPetals) / (2.5 * 3.14159), 1.0);

    // Define the base length of the petal (fixed as per your current settings)
    float baseLength = smoothstep(thickness, thickness * 0.5, abs(petalAngle - 0.5));

    // Extend the petal towards the outer edge and adjust its angle
    if (radius > 0.35 && radius < extensionLength) {
        // Calculate how much to extend the petal
        float extensionFactor = smoothstep(0.35, extensionLength, radius);
        // Adjust the petal angle to form a triangular connection
        petalAngle = mod(angle * float(numPetals) / (2.5 * 3.14159), 5.0) * extensionFactor;

        // Connect the petals to form a triangle shape
        float triangleEdge = smoothstep(thickness, thickness * 0.5, abs(petalAngle - 0.5));
        return max(baseLength, triangleEdge);
    }

    return baseLength;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy / iResolution.xy;
    uv -= 0.5;
    uv.x *= iResolution.x / iResolution.y;

    float windowRadius = 0.45;
    float distFromCenter = length(uv);

    // Apply a sine-based distortion to create a wavy circle effect
    float waveAmount = 0.015;  // Wave intensity for subtler curviness
    float waveFrequency = 8.0;  // Number of waves
    float rotationSpeed = time() * 0.1;  // Synchronize with the circles' rotation
    float angle = atan(uv.y, uv.x);

    // Apply rotation transformation to synchronize with the circles
    float cosAngle = cos(rotationSpeed);
    float sinAngle = sin(rotationSpeed);
    vec2 rotatedUV = vec2(cosAngle * uv.x - sinAngle * uv.y, sinAngle * uv.x + cosAngle * uv.y);

    // Calculate the wave distortion based on the rotated angle
    float waveDistortion = waveAmount * sin(waveFrequency * angle + rotationSpeed);

    // Adjust the distance from the center using the wave distortion
    distFromCenter += waveDistortion;

    // Spherical distortion for the 3D effect
    float sphereDistortion = sqrt(1.0 - pow(distFromCenter / windowRadius, 2.0));
    vec3 sphereNormal = normalize(vec3(rotatedUV, sphereDistortion));  // Normal pointing outwards from the sphere

    // Light source direction and color
    vec3 lightDir = normalize(vec3(-0.5, 0.5, 1.0));
    float diffuse = max(dot(sphereNormal, lightDir), 0.0);

    // Use procedural randomness for the frame thickness
    if (distFromCenter > windowRadius && distFromCenter < windowRadius + 0.01) {
        // Dynamic procedural pattern for the frame with varying thickness
        vec3 frameColor = calculateFrameLighting(rotatedUV, distFromCenter, windowRadius);
        fragColor = vec4(frameColor * diffuse, 1.0); // Apply lighting
    } else if (distFromCenter < windowRadius) {
        // Static procedural pattern inside the curvy window
        vec3 proceduralTexture = renderProceduralTextureInWindow(rotatedUV, distFromCenter, windowRadius);
        
        // Render circular shapes instead of petals
        vec3 circularShapeColor = renderCircularShapes(rotatedUV);
      
        // Increase the number of radial lines (petals) by adjusting numPetals parameter
        float petalEffect = drawConnectedDarkGrayPetals(rotatedUV, 22, 0.08, 2.05, 5.0);  // Extend length to 0.8 radius
        vec3 darkGrayPetals = vec3(0.15) * petalEffect;  // Dark gray color for petals

        // Combine the procedural texture, black border, circular shapes, and dark gray petal pattern
        vec3 finalColor = (proceduralTexture + circularShapeColor + darkGrayPetals) * diffuse;  // Apply lighting
        fragColor = vec4(finalColor, 1.0); // Opacity set to 1.0 for full opacity
    } else {
        vec2 p = (-res() + 3.0 * fragCoord) / res().y;  
        vec3 col = renderBackground(p);  
        col = pow(col, vec3(1.0 / 2.2));  
        fragColor = vec4(col, 1);
    }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

